/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http.server;

import static java.lang.Thread.currentThread;

import org.mule.api.annotation.Experimental;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.http.domain.message.request.HttpRequestContext;
import org.mule.sdk.api.http.server.async.HttpResponseReadyCallback;

/**
 * Handler for an incoming HTTP request that allows to send the HTTP response asynchronously.
 *
 * @since 0.12.0
 */
@Experimental
@MinMuleVersion("4.10.0")
public interface RequestHandler {

  /**
   * Called to handle an incoming HTTP request
   *
   * @param requestContext   HTTP request content
   * @param responseCallback callback to call when the response content is ready.
   */
  void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback);

  /**
   * @return the classloader for the artifact that owns this {@link RequestHandler}.
   */
  default ClassLoader getContextClassLoader() {
    return currentThread().getContextClassLoader();
  }

}
