/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.http;

import org.mule.api.annotation.Experimental;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.http.client.ClientCreationException;
import org.mule.sdk.api.http.client.HttpClient;
import org.mule.sdk.api.http.client.HttpClientConfigurer;
import org.mule.sdk.api.http.domain.entity.HttpEntityFactory;
import org.mule.sdk.api.http.domain.message.request.HttpRequestBuilder;
import org.mule.sdk.api.http.domain.message.response.HttpResponse;
import org.mule.sdk.api.http.domain.message.response.HttpResponseBuilder;
import org.mule.sdk.api.http.server.HttpServer;
import org.mule.sdk.api.http.server.HttpServerConfigurer;
import org.mule.sdk.api.http.server.ServerCreationException;

import java.util.function.Consumer;

/**
 * Entry point to use the HTTP support in any extension.
 *
 * @since 0.12.0
 */
@Experimental
@MinMuleVersion("4.10.0")
public interface HttpService {

  /**
   * Creates a {@link HttpClient}.
   *
   * @param configCallback a callback to configure the client.
   * @return the {@link HttpClient}.
   * @throws ClientCreationException if an error happens.
   */
  HttpClient client(Consumer<HttpClientConfigurer> configCallback) throws ClientCreationException;

  /**
   * Creates a {@link HttpServer}.
   *
   * @param configCallback a callback to configure the server.
   * @return the {@link HttpServer}.
   * @throws ServerCreationException if an error happens.
   */
  HttpServer server(Consumer<HttpServerConfigurer> configCallback) throws ServerCreationException;

  /**
   * @return a new {@link HttpResponseBuilder}
   */
  HttpResponseBuilder responseBuilder();

  /**
   * @param original another instance to be copied.
   * @return a new {@link HttpResponseBuilder}
   */
  HttpResponseBuilder responseBuilder(HttpResponse original);

  /**
   * @return a new {@link HttpRequestBuilder}
   */
  HttpRequestBuilder requestBuilder();

  /**
   * @param preserveHeaderCase whether the request should preserve the header case.
   * @return a new {@link HttpRequestBuilder}
   */
  HttpRequestBuilder requestBuilder(boolean preserveHeaderCase);

  /**
   * @return the utility {@link HttpEntityFactory} to create entities.
   */
  HttpEntityFactory entityFactory();
}
