/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.queue;

import org.mule.api.annotation.NoImplement;

import java.util.Optional;

/**
 * A Queue manager is responsible for managing one or more Queue resources and providing common support for transactions and
 * persistence.
 *
 * @since 1.0
 */
@NoImplement
public interface QueueManager {

  String OBJECT_QUEUE_MANAGER = "_muleSdkApiQueueManager";

  /**
   * Returns a new instance of {@link QueueSession} bounded to this {@link QueueManager}
   *
   * @return session for retrieving queues and handle transactions
   */
  QueueSession getQueueSession();

  /**
   * Returns the configuration of the {@link Queue} of the given {@code queueName}
   *
   * @param queueName the name of a configured queue
   * @return the queue's configuration or {@link Optional#empty()} if no such queue
   */
  Optional<QueueConfiguration> getQueueConfiguration(String queueName);

  /**
   * Configures the defined queue.
   *
   * @param queueName              the name of a queue to be configured.
   * @param maxOutstandingMessages the max outstanding messages to be set for the configuration.
   * @param persistent             if the queue should be configured to be persistent.
   */
  void configureQueue(String queueName, int maxOutstandingMessages, boolean persistent);
}

