/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.tx;

import org.mule.sdk.api.annotation.MinMuleVersion;

/**
 * The type of beginning actions that sources can take regarding transactions.
 *
 * @since 1.0
 */
@MinMuleVersion("4.5.0")
public enum SourceTransactionalAction {

  /**
   * Will ensure that a new transaction is created for each invocation
   * <p>
   * J2EE RequiresNew
   */
  @MinMuleVersion("4.5.0")
  ALWAYS_BEGIN,

  /**
   * Whether there is a transaction available or not, ignore it
   * <p>
   * J2EE: NotSupported
   */
  @MinMuleVersion("4.5.0")
  NONE
}
