/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.metadata;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.api.annotation.Experimental;
import org.mule.metadata.api.model.UnionType;
import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.metadata.resolving.OutputTypeResolver;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Applied to router components, specifies to the DataSense engine that the payload/attributes types that will exit the owning
 * router component is the union of the payload/attributes of each route in the router. This symbolizes that the result will be
 * the output of (any) one of the routes.
 * <p>
 * This can be considered as a shortcut of a {@link OutputTypeResolver} that returns an {@link UnionType} with the types from each
 * of the routes.
 * <p>
 * <b>NOTE:</b> Experimental feature. Backwards compatibility is not guaranteed.
 *
 * @since 0.10.0
 */
@Target({METHOD})
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.8.0")
@DoNotEnforceMinMuleVersion
@Experimental
public @interface OneOfRoutesOutputChainResolver {
}
