/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Container for the {@link Repeatable} {@link ExternalLib} annotation
 *
 * @since 1.0
 */
@Target(TYPE)
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.5.0")
public @interface ExternalLibs {

  /**
   * @return all the {@link ExternalLib} declarations on the annotated element
   */
  ExternalLib[] value() default {};
}
