/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.sdk.api.meta.JavaVersion;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Used in the same class as {@code @Extension}, this annotation indicates the versions of Java supported by the extension.
 *
 * Starting with Mule 4.5, any Extension not explicitly using this annotation will be assumed to be compatible with Java 8 and 11
 * only.
 *
 * @since 1.0
 */
@Target(TYPE)
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.5.0")
public @interface JavaVersionSupport {

  /**
   * @return The supported Java versions
   */
  JavaVersion[] value();
}
