/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.data.sample;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.api.annotation.Experimental;
import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.annotation.binding.Binding;
import org.mule.sdk.api.data.sample.SampleDataProvider;
import org.mule.sdk.api.runtime.source.Source;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Associates a {@link Source} class or operation method with a {@link SampleDataProvider}.
 *
 * <b>NOTE:</b> Experimental feature. Backwards compatibility not guaranteed.
 *
 * @since 1.4.0
 * @see SampleDataProvider
 */
@Target({TYPE, METHOD})
@Retention(RUNTIME)
@Documented
@Experimental
@MinMuleVersion("4.4")
@DoNotEnforceMinMuleVersion
public @interface SampleData {

  /**
   * @return the associated {@link SampleDataProvider}
   */
  Class<? extends SampleDataProvider> value();

  /**
   * @return bindings between parameters in the {@link SampleData#value()} to extraction expressions.
   */
  Binding[] bindings() default {};

}
