/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.execution;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.sdk.api.annotation.DoNotEnforceMinMuleVersion;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.runtime.operation.ExecutionType;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Allows to specify the {@link ExecutionType} of the annotated component.
 * <p>
 * Usage of this annotation is completely optional. If not provided, the runtime will perform a best guess on what the best
 * {@link ExecutionType} is.
 *
 * @since 1.0
 */
@Target(METHOD)
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.5.0")
@DoNotEnforceMinMuleVersion
public @interface Execution {

  ExecutionType value();
}
