/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.metadata.resolving;

import org.mule.metadata.api.model.MetadataType;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.metadata.MetadataContext;

/**
 * {@link StaticResolver} implementation for the {@link OutputModel}s.
 * <p>
 * This {@link OutputTypeResolver} is discarded once the extension model is built. It's not registered with the dynamic
 * {@link OutputTypeResolver}s.
 *
 */
@MinMuleVersion("4.5.0")
public abstract class OutputStaticTypeResolver implements OutputTypeResolver, StaticResolver {

  /**
   * {@inheritDoc}
   * <p>
   * The category name is not used for {@link StaticResolver}s since they are not registered in the extension.
   */
  @Override
  public String getCategoryName() {
    return "OUTPUT_" + STATIC_RESOLVER_NAME;
  }

  /**
   * This method resolves the static output type for a {@link OutputModel} proxing to the
   * {@link StaticResolver#getStaticMetadata()} method.
   * <p>
   * The context and key are not used nor injected.
   */
  @Override
  final public MetadataType getOutputType(MetadataContext context, Object key) {
    return getStaticMetadata();
  }
}
