/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.runtime.parameter;

import org.mule.api.annotation.NoImplement;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.annotation.execution.OnError;
import org.mule.sdk.api.annotation.execution.OnSuccess;

import java.util.Optional;

/**
 * Provides message correlation information. Operations and source callbacks (such as methods annotated with {@link OnSuccess}
 * or @{@link OnError}) can obtain an instance in order to obtain information regarding how the message being processed correlates
 * to its context.
 *
 * @since 1.0
 */
@NoImplement
@MinMuleVersion("4.5.0")
public interface CorrelationInfo {

  /**
   * @return The id of the {@link Event} being processed
   */
  String getEventId();

  /**
   * Indicates if outbound correlation ids are enabled at the application level or not. If {@code false}, outbound operations
   * should not send correlation id, unless that operation has an explicit override.
   *
   * @return whether outbound correlation ids is enabled by default or not
   */
  boolean isOutboundCorrelationEnabled();

  /**
   * @return The correlation id of the {@link Event} currently being processed
   */
  String getCorrelationId();

  /**
   * @return The item sequence information of the {@link Event} currently being processed
   */
  Optional<ItemSequenceInfo> getItemSequenceInfo();
}
