/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.sdk.api.annotation.semantics.security;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import org.mule.sdk.api.annotation.MinMuleVersion;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Indicates that the annotated parameter holds a value which should be encrypted.
 * <p>
 * Typical examples include sshKeys, digital signatures, credit card numbers, personal or financial information, or any type of
 * sensitive scalar values.
 * <p>
 * For passwords, use {@link Password} instead.
 * <p>
 * For secret tokens, use {@link SecretToken}.
 * <p>
 * <b>NOTE:</b> This annotation merely signals that the value should be encrypted. Actual encrypted not enforced by this
 * annotation
 *
 * @see Password
 * @see SecretToken
 * @since 1.0
 */
@Target({FIELD, PARAMETER, TYPE})
@Retention(RUNTIME)
@Documented
@MinMuleVersion("4.4")
public @interface Secret {
}
