/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.sdk.api.runtime.source;

import org.mule.sdk.api.annotation.MinMuleVersion;

import java.util.Map;

/**
 * This is a manager for handling distributed tracing for sources/operations.
 *
 * @since 1.0
 */
@MinMuleVersion("4.5")
public interface DistributedTraceContextManager {

  /**
   * @param contextMap the string/string key/value that stores the information of the remote trace context.
   */
  void setRemoteTraceContextMap(Map<String, String> contextMap);

  /**
   * @return the context map corresponding to the remote trace context.
   */
  Map<String, String> getRemoteTraceContextMap();
}
