/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.sdk.compatibility.api.utils;

import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

/**
 * Helper class that allows connectors to consume new features that are exposed through an implicit method argument.
 *
 * @since 4.5
 */
@MinMuleVersion("4.5.0")
public interface ForwardCompatibilityHelper {

  /**
   * To be used by Sources to obtain the {@link DistributedTraceContextManager} associated to the source callback context.
   *
   * @param sourceCallbackContext the {@link SourceCallbackContext} of the calling source.
   * @return the associated {@link DistributedTraceContextManager}.
   */
  DistributedTraceContextManager getDistributedTraceContextManager(SourceCallbackContext sourceCallbackContext);

  /**
   * To be used by Operations to obtain the {@link DistributedTraceContextManager} associated to the current event context.
   *
   * @param correlationInfo the {@link CorrelationInfo} of the current event.
   * @return the associated {@link DistributedTraceContextManager}.
   */
  DistributedTraceContextManager getDistributedTraceContextManager(CorrelationInfo correlationInfo);

  /**
   * To be used by Operations to obtain the {@link DistributedTraceContextManager} associated to the current event context.
   *
   * @param correlationInfo the {@link org.mule.sdk.api.runtime.parameter.CorrelationInfo} of the current event.
   * @return the associated {@link DistributedTraceContextManager}.
   */
  DistributedTraceContextManager getDistributedTraceContextManager(org.mule.sdk.api.runtime.parameter.CorrelationInfo correlationInfo);

}
