/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.weave.connectivity;

import com.mulesoft.connectivity.linkweave.api.model.BaseExecutableComponentModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.BaseConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionProviderModel;
import com.mulesoft.connectivity.linkweave.api.model.connection.ConnectionValidationResult;
import com.mulesoft.connectivity.linkweave.api.model.connection.TestConnectionModel;
import com.mulesoft.connectivity.linkweave.api.model.provider.ValueProviderModel;
import com.mulesoft.connectivity.linkweave.api.util.SerializationUtil;
import com.mulesoft.connectivity.mule.api.MuleConnectivityService;
import com.mulesoft.connectivity.mule.api.Page;
import com.mulesoft.connectivity.mule.api.ServiceConfiguration;
import com.mulesoft.connectivity.mule.api.operation.OperationResult;
import com.mulesoft.connectivity.mule.api.operation.ResultError;
import com.mulesoft.connectivity.mule.api.trigger.NextData;
import com.mulesoft.connectivity.mule.api.trigger.TriggerPage;
import com.mulesoft.connectivity.mule.api.valueprovider.ProvidedValue;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.mule.service.weave.connectivity.ConverterUtil;
import org.mule.service.weave.connectivity.ModelBuilderUtils;
import org.mule.service.weave.connectivity.ModelInterpreterProvider;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public class MuleConnectivityServiceImpl
implements MuleConnectivityService {
    protected ModelInterpreterProvider modelInterpreterProvider;

    public MuleConnectivityServiceImpl(DataWeaveScriptingEngine dataWeaveScriptingEngine) {
        this.modelInterpreterProvider = new ModelInterpreterProvider(dataWeaveScriptingEngine);
    }

    public org.mule.runtime.api.connection.ConnectionValidationResult testConnectivity(String testConnectionModelReference, String connectionProviderModelReference, Map<String, Object> connectionInfo, ServiceConfiguration serviceConfiguration) {
        TestConnectionModel testConnectionModel = ModelBuilderUtils.buildTestConnectionModel(testConnectionModelReference);
        BaseConnectionProviderModel connectionProviderModel = ModelBuilderUtils.buildConnectionProviderModel(connectionProviderModelReference, testConnectionModel);
        ConnectionValidationResult connectionValidationResult = this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).testConnection(testConnectionModel, connectionProviderModel, connectionInfo);
        if (connectionValidationResult.isValid()) {
            return org.mule.runtime.api.connection.ConnectionValidationResult.success();
        }
        return org.mule.runtime.api.connection.ConnectionValidationResult.failure((String)connectionValidationResult.getErrorMessage().orElse(null), (Exception)new Exception(connectionValidationResult.getErrorDetails().orElse(null)));
    }

    public OperationResult<Object> executeOperation(String connectionProviderModelReference, Map<String, Object> connectionInfo, String operationModelReference, Map<String, Object> parameters, boolean isPaginated, ServiceConfiguration serviceConfiguration) {
        BaseConnectionProviderModel connectionProviderModel = ModelBuilderUtils.buildConnectionProviderModel(connectionProviderModelReference, null);
        BaseExecutableComponentModel<?> operationModel = ModelBuilderUtils.buildExecutableComponentModel(operationModelReference, operationModelReference, isPaginated);
        com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult operationResult = this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).executeOperation(connectionProviderModel, connectionInfo, operationModel, parameters);
        return this.getObjectOperationResult((com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult<Object>)operationResult);
    }

    public OperationResult<Object> executeOperationNextPage(String connectionProviderModelReference, Map<String, Object> connectionInfo, String operationModelReference, Object nextPageData, ServiceConfiguration serviceConfiguration) {
        BaseConnectionProviderModel connectionProviderModel = ModelBuilderUtils.buildConnectionProviderModel(connectionProviderModelReference, null);
        BaseExecutableComponentModel<?> operationModel = ModelBuilderUtils.buildExecutableComponentModel(operationModelReference, operationModelReference, true);
        com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult operationResult = this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).executeOperationNextPage(connectionProviderModel, connectionInfo, operationModel, nextPageData);
        return this.getObjectOperationResult((com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult<Object>)operationResult);
    }

    private OperationResult<Object> getObjectOperationResult(com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult<Object> operationResult) {
        if (operationResult.isSuccess()) {
            Object operationResultValue = operationResult.getValue();
            if (operationResultValue instanceof com.mulesoft.connectivity.linkweave.api.model.Page) {
                com.mulesoft.connectivity.linkweave.api.model.Page linkweavePage = (com.mulesoft.connectivity.linkweave.api.model.Page)operationResultValue;
                Page apiPage = ConverterUtil.convertToApiPage(linkweavePage);
                return OperationResult.success(apiPage);
            }
            return OperationResult.success((Object)operationResultValue);
        }
        return OperationResult.failure((ResultError)ConverterUtil.toApiResultError(operationResult.getErrorValue()));
    }

    public OperationResult<Page<ProvidedValue>> executeValueProvider(String connectionProviderModelReference, Map<String, Object> connectionInfo, String valueProviderModelReference, Map<String, Object> parameters, boolean isPaginated, ServiceConfiguration serviceConfiguration) {
        ConnectionProviderModel connectionProviderModel = ModelBuilderUtils.getConnectionProviderModel(connectionProviderModelReference);
        ValueProviderModel valueProviderModel = ModelBuilderUtils.getValueProviderModel(valueProviderModelReference, isPaginated);
        com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult valueProviderResult = this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).executeValueProvider(connectionProviderModel, connectionInfo, valueProviderModel, parameters);
        if (valueProviderResult.isSuccess()) {
            return OperationResult.success(ConverterUtil.convertToApiValueProviderPage((com.mulesoft.connectivity.linkweave.api.model.Page<com.mulesoft.connectivity.linkweave.api.model.provider.ProvidedValue>)((com.mulesoft.connectivity.linkweave.api.model.Page)valueProviderResult.getValue())));
        }
        return OperationResult.failure((ResultError)ConverterUtil.toApiResultError(valueProviderResult.getErrorValue()));
    }

    public OperationResult<Page<ProvidedValue>> executeValueProviderNextPage(String connectionProviderModelReference, Object connectionInfo, String valueProviderModelReference, Object nextPageData, ServiceConfiguration serviceConfiguration) {
        ConnectionProviderModel connectionProviderModel = ModelBuilderUtils.getConnectionProviderModel(connectionProviderModelReference);
        ValueProviderModel valueProviderModel = ModelBuilderUtils.getValueProviderModel(valueProviderModelReference, true);
        com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult valueProviderResult = this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).executeValueProviderNextPage(connectionProviderModel, connectionInfo, valueProviderModel, nextPageData);
        if (valueProviderResult.isSuccess()) {
            return OperationResult.success(ConverterUtil.convertToApiValueProviderPage((com.mulesoft.connectivity.linkweave.api.model.Page<com.mulesoft.connectivity.linkweave.api.model.provider.ProvidedValue>)((com.mulesoft.connectivity.linkweave.api.model.Page)valueProviderResult.getValue())));
        }
        return OperationResult.failure((ResultError)ConverterUtil.toApiResultError(valueProviderResult.getErrorValue()));
    }

    public OperationResult<TriggerPage> executeTrigger(String connectionProviderModelReference, Map<String, Object> connectionInfo, String triggerModelReference, Object watermark, Map<String, Object> parameters, ServiceConfiguration serviceConfiguration) {
        Objects.requireNonNull(watermark);
        BaseConnectionProviderModel connectionProviderModel = ModelBuilderUtils.buildConnectionProviderModel(connectionProviderModelReference, null);
        BaseExecutableComponentModel<?> triggerModel = ModelBuilderUtils.buildExecutableComponentModel(triggerModelReference, triggerModelReference, true);
        com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult triggerResult = this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).executeTrigger(connectionProviderModel, connectionInfo, triggerModel, watermark, parameters);
        if (triggerResult.isSuccess()) {
            return OperationResult.success((Object)ConverterUtil.convertToApiTriggerPage((com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage)triggerResult.getValue()));
        }
        return OperationResult.failure((ResultError)ConverterUtil.toApiResultError(triggerResult.getErrorValue()));
    }

    public OperationResult<TriggerPage> executeTriggerNextPage(String connectionProviderModelReference, Map<String, Object> connectionInfo, String triggerModelReference, NextData nextData, ServiceConfiguration serviceConfiguration) {
        Objects.requireNonNull(nextData);
        com.mulesoft.connectivity.linkweave.api.model.trigger.NextData linkweaveNextData = ConverterUtil.convertTolinkweaveNextData(nextData);
        BaseConnectionProviderModel connectionProviderModel = ModelBuilderUtils.buildConnectionProviderModel(connectionProviderModelReference, null);
        BaseExecutableComponentModel<?> triggerModel = ModelBuilderUtils.buildExecutableComponentModel(triggerModelReference, triggerModelReference, true);
        com.mulesoft.connectivity.linkweave.api.model.operation.OperationResult triggerResult = this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).executeTriggerNextPage(connectionProviderModel, connectionInfo, triggerModel, linkweaveNextData);
        if (triggerResult.isSuccess()) {
            return OperationResult.success((Object)ConverterUtil.convertToApiTriggerPage((com.mulesoft.connectivity.linkweave.api.model.trigger.TriggerPage)triggerResult.getValue()));
        }
        return OperationResult.failure((ResultError)ConverterUtil.toApiResultError(triggerResult.getErrorValue()));
    }

    public int executeTriggerCompareWatermark(String triggerModelReference, Object param1, Object param2, ServiceConfiguration serviceConfiguration) {
        BaseExecutableComponentModel<?> triggerModel = ModelBuilderUtils.buildExecutableComponentModel(triggerModelReference, triggerModelReference, false);
        return this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).executeTriggerCompareWatermark(triggerModel, param1, param2);
    }

    public Serializable getInitialWatermark(String connectionProviderModelReference, Map<String, Object> connectionInfo, String triggerModelReference, Map<String, Object> parameters, ServiceConfiguration serviceConfiguration) {
        BaseConnectionProviderModel connectionProviderModel = ModelBuilderUtils.buildConnectionProviderModel(connectionProviderModelReference, null);
        BaseExecutableComponentModel<?> triggerModel = ModelBuilderUtils.buildExecutableComponentModel(triggerModelReference, triggerModelReference, true);
        return this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).getInitialWatermark(connectionProviderModel, connectionInfo, triggerModel, parameters);
    }

    public String serializeWatermarkObject(Object object, ServiceConfiguration serviceConfiguration) {
        SerializationUtil serializationUtil = this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).getSerializationUtil();
        return serializationUtil.serializeObject(object);
    }

    public Object deserializeWatermarkObject(Object object, ServiceConfiguration serviceConfiguration) {
        SerializationUtil serializationUtil = this.modelInterpreterProvider.getModelInterpreter(serviceConfiguration).getSerializationUtil();
        return serializationUtil.deserializeObject(object);
    }

    public String getName() {
        return "Connectivity DataWeave Service";
    }
}

