/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.weave.connectivity;

import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.mule.api.ServiceConfiguration;
import java.util.Map;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.service.weave.connectivity.HttpClientServiceAdapter;
import org.mule.weave.v2.module.http.service.HttpClientService;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public class ModelInterpreterProvider {
    private static final Map<String, Class<?>> CLIENT_TYPE_TO_SERVICE_CLASS_MAP = Map.of(ServiceConfiguration.CLIENT_TYPE.HTTPCLIENT.toString(), HttpClientService.class);
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine;

    public ModelInterpreterProvider(DataWeaveScriptingEngine dataWeaveScriptingEngine) {
        this.dataWeaveScriptingEngine = dataWeaveScriptingEngine;
    }

    public ModelInterpreter getModelInterpreter(ServiceConfiguration serviceConfiguration) {
        Object v = serviceConfiguration.getConfig().get(ServiceConfiguration.CLIENT_TYPE.HTTPCLIENT.toString());
        if (v instanceof HttpClient) {
            HttpClient httpClient = (HttpClient)v;
            ModelInterpreterConfig config = new ModelInterpreterConfig.Builder().addService(CLIENT_TYPE_TO_SERVICE_CLASS_MAP.get(ServiceConfiguration.CLIENT_TYPE.HTTPCLIENT.toString()), (Object)new HttpClientServiceAdapter(httpClient)).build();
            return new ModelInterpreter(this.dataWeaveScriptingEngine, config);
        }
        throw new IllegalArgumentException(String.valueOf(serviceConfiguration.getConfig().get(ServiceConfiguration.CLIENT_TYPE.HTTPCLIENT.toString())) + " is not an instance of " + HttpClientService.class.getName());
    }
}

