/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.weave.connectivity;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.weave.v2.module.http.service.HttpClient;
import org.mule.weave.v2.module.http.service.HttpClientConfiguration;
import org.mule.weave.v2.module.http.service.HttpClientHeaders;
import org.mule.weave.v2.module.http.service.HttpClientRequest;
import org.mule.weave.v2.module.http.service.HttpClientResponse;
import org.mule.weave.v2.module.http.service.HttpClientService;

public class HttpClientServiceAdapter
implements HttpClientService {
    public static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    private final org.mule.runtime.http.api.client.HttpClient runtimeHttpClient;

    public HttpClientServiceAdapter(org.mule.runtime.http.api.client.HttpClient httpClient) {
        this.runtimeHttpClient = httpClient;
    }

    public HttpClient getClient(HttpClientConfiguration httpClientConfiguration) {
        return httpClientRequest -> {
            HttpRequestBuilder runtimeRequestBuilder = this.buildRuntimeHttpRequestBuilder(httpClientRequest);
            HttpResponse runtimeHttpResponse = this.executeHttpRequest(this.runtimeHttpClient, runtimeRequestBuilder);
            return this.buildHttpClientResponse(runtimeHttpResponse);
        };
    }

    private HttpResponse executeHttpRequest(org.mule.runtime.http.api.client.HttpClient runtimeHttpClient, HttpRequestBuilder runtimeRequestBuilder) {
        try {
            return runtimeHttpClient.send(runtimeRequestBuilder.build(), HttpRequestOptions.builder().followsRedirect(false).build());
        }
        catch (IOException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpRequestBuilder buildRuntimeHttpRequestBuilder(HttpClientRequest httpClientRequest) {
        HttpRequestBuilder runtimeRequestBuilder = HttpRequest.builder().uri(httpClientRequest.getUrl()).method(httpClientRequest.getMethod());
        if (httpClientRequest.getBody() != null) {
            runtimeRequestBuilder.entity((HttpEntity)new InputStreamHttpEntity(httpClientRequest.getBody()));
        }
        httpClientRequest.getHeaders().getHeaders().forEach(httpHeader -> runtimeRequestBuilder.addHeader(httpHeader.getName(), httpHeader.getValue()));
        return runtimeRequestBuilder;
    }

    private HttpClientResponse buildHttpClientResponse(final HttpResponse runtimeHttpResponse) {
        return new HttpClientResponse(){

            public int getStatus() {
                return runtimeHttpResponse.getStatusCode();
            }

            public Optional<String> getStatusText() {
                return Optional.ofNullable(runtimeHttpResponse.getReasonPhrase());
            }

            public HttpClientHeaders getHeaders() {
                return HttpClientServiceAdapter.this.buildHttpClientHeaders(runtimeHttpResponse);
            }

            public Optional<String> getContentType() {
                return this.getHeaders().firstValueIgnoreCase(HttpClientServiceAdapter.CONTENT_TYPE_HEADER_NAME);
            }

            public Optional<InputStream> getBody() {
                return Optional.ofNullable(runtimeHttpResponse.getEntity().getContent());
            }
        };
    }

    private HttpClientHeaders buildHttpClientHeaders(HttpResponse runtimeHttpResponse) {
        ArrayList httpHeaderList = new ArrayList();
        runtimeHttpResponse.getHeaders().forEach((key, value) -> httpHeaderList.add(HttpClientHeaders.HttpHeader.of((String)key, (String)value)));
        return new HttpClientHeaders(httpHeaderList);
    }
}

