/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.weave.connectivity;

import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.mule.api.ServiceConfiguration;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.service.weave.connectivity.HttpClientServiceAdapter;
import org.mule.weave.v2.module.http.service.HttpClientService;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;

public class ModelInterpreterProvider {
    private static final Map<String, Class<?>> CLIENT_TYPE_TO_SERVICE_CLASS_MAP = Map.of(ServiceConfiguration.CLIENT_TYPE.HTTPCLIENT.toString(), HttpClientService.class);
    private static final int MAX_CACHE_SIZE = 2000;
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine;
    private final Map<Object, Object> cache;

    public ModelInterpreterProvider(DataWeaveScriptingEngine dataWeaveScriptingEngine) {
        this.dataWeaveScriptingEngine = dataWeaveScriptingEngine;
        this.cache = Collections.synchronizedMap(new LRUMap(2000));
    }

    public ModelInterpreter getModelInterpreter(ServiceConfiguration serviceConfiguration) {
        Object v = serviceConfiguration.getConfig().get(ServiceConfiguration.CLIENT_TYPE.HTTPCLIENT.toString());
        if (v instanceof HttpClient) {
            HttpClient httpClient = (HttpClient)v;
            ModelInterpreterConfig config = new ModelInterpreterConfig.Builder().addService(CLIENT_TYPE_TO_SERVICE_CLASS_MAP.get(ServiceConfiguration.CLIENT_TYPE.HTTPCLIENT.toString()), (Object)new HttpClientServiceAdapter(httpClient)).cache(this.cache).build();
            return new ModelInterpreter(this.dataWeaveScriptingEngine, config);
        }
        throw new IllegalArgumentException(String.valueOf(serviceConfiguration.getConfig().get(ServiceConfiguration.CLIENT_TYPE.HTTPCLIENT.toString())) + " is not an instance of " + HttpClientService.class.getName());
    }
}

