/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.service.http.netty.impl.client.NettyHttpClient;

public class HttpClientConnectionManager
implements HttpClientFactory {
    private static final int CLIENT_SELECTOR_THREAD_COUNT = Integer.getInteger("mule.http.client.selectors.count", Integer.max(Runtime.getRuntime().availableProcessors(), 2));
    private final SchedulerService schedulerService;
    private final Map<String, HttpClient> clients = new ConcurrentHashMap<String, HttpClient>();

    public HttpClientConnectionManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    protected HttpClientConnectionManager() {
        this(null);
    }

    public HttpClient getOrCreateClient(String name, Supplier<? extends HttpClientConfiguration> configuration) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Client name can't be null");
        return this.clients.computeIfAbsent(name, serverName -> this.create((HttpClientConfiguration)configuration.get()));
    }

    public HttpClient create(HttpClientConfiguration configuration) {
        try {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"Client configuration can't be null");
            NettyHttpClient.Builder builder = NettyHttpClient.builder().withSslContext(this.createSslContext(configuration)).withConnectionIdleTimeout(configuration.getConnectionIdleTimeout()).withUsingPersistentConnections(configuration.isUsePersistentConnections()).withSelectorsScheduler(this.createSelectorsScheduler()).withSelectorsCount(CLIENT_SELECTOR_THREAD_COUNT).withMaxConnections(configuration.getMaxConnections());
            return this.enrichClientBuilder(builder, configuration).build();
        }
        catch (IllegalArgumentException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Scheduler createSelectorsScheduler() {
        if (this.schedulerService == null) {
            return null;
        }
        return this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(CLIENT_SELECTOR_THREAD_COUNT).withName("http.requester"), 0);
    }

    protected NettyHttpClient.Builder enrichClientBuilder(NettyHttpClient.Builder builder, HttpClientConfiguration configuration) {
        return builder;
    }

    private SslContext createSslContext(HttpClientConfiguration configuration) {
        TlsContextFactory tlsContextFactory = configuration.getTlsContextFactory();
        if (tlsContextFactory == null) {
            return null;
        }
        try {
            return new JdkSslContext(tlsContextFactory.createSslContext(), true, this.getCiphers(tlsContextFactory), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, new String[]{"http/1.1"}), ClientAuth.NONE, tlsContextFactory.getEnabledProtocols(), false);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Iterable<String> getCiphers(TlsContextFactory tlsContextFactory) {
        if (tlsContextFactory == null) {
            return null;
        }
        String[] enabledCipherSuites = tlsContextFactory.getEnabledCipherSuites();
        if (enabledCipherSuites == null) {
            return null;
        }
        return Arrays.asList(enabledCipherSuites);
    }
}

