/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpClientFactory;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.util.SslContextHelper;

public class HttpClientConnectionManager
implements HttpClientFactory {
    private static final int CLIENT_SELECTOR_THREAD_COUNT = Integer.getInteger("mule.http.client.selectors.count", Integer.max(Runtime.getRuntime().availableProcessors(), 2));
    private final SchedulerService schedulerService;
    private final Map<String, HttpClient> clients = new ConcurrentHashMap<String, HttpClient>();

    public HttpClientConnectionManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    protected HttpClientConnectionManager() {
        this(null);
    }

    public HttpClient getOrCreateClient(String name, Supplier<? extends HttpClientConfiguration> configuration) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Client name can't be null");
        return this.clients.computeIfAbsent(name, serverName -> this.create((HttpClientConfiguration)configuration.get()));
    }

    public HttpClient create(HttpClientConfiguration configuration) {
        try {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"Client configuration can't be null");
            NettyHttpClient.Builder builder = NettyHttpClient.builder().withProxyConfig(configuration.getProxyConfig()).withSslContext(SslContextHelper.sslContextForClient(configuration.getTlsContextFactory())).withConnectionIdleTimeout(configuration.getConnectionIdleTimeout()).withUsingPersistentConnections(configuration.isUsePersistentConnections()).withSelectorsScheduler(this.createSelectorsScheduler()).withSelectorsCount(CLIENT_SELECTOR_THREAD_COUNT).withMaxConnections(configuration.getMaxConnections());
            return this.enrichClientBuilder(builder, configuration).build();
        }
        catch (IllegalArgumentException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Scheduler createSelectorsScheduler() {
        if (this.schedulerService == null) {
            return null;
        }
        return this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(CLIENT_SELECTOR_THREAD_COUNT).withName("http.requester"), 0);
    }

    protected NettyHttpClient.Builder enrichClientBuilder(NettyHttpClient.Builder builder, HttpClientConfiguration configuration) {
        return builder;
    }
}

