/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
import org.mule.api.annotation.jpms.ServiceModule;

/**
 * Netty based implementation of the HTTP Service.
 *
 * @moduleGraph
 */
@ServiceModule
module org.mule.service.http.netty {
  requires org.mule.runtime.api.annotations;

  requires org.mule.runtime.api;
  requires org.mule.runtime.http.api;
  requires org.mule.runtime.core;

  requires io.netty.buffer;
  requires io.netty.codec;
  requires io.netty.codec.http;
  requires io.netty.codec.http2;
  requires io.netty.common;
  requires io.netty.handler;
  requires io.netty.handler.proxy;
  requires io.netty.resolver.dns;
  requires io.netty.resolver;
  requires io.netty.transport;

  requires com.github.benmanes.caffeine;
  requires com.google.common;
  requires jakarta.mail;
  requires org.apache.commons.io;
  requires org.apache.commons.lang3;
  requires reactor.netty.http;
  requires reactor.netty.core;
  requires org.reactivestreams;
  requires reactor.core;
  requires org.apache.commons.codec;

  // javax.activation
  requires transitive jakarta.activation;

  exports org.mule.service.http.netty.impl.provider to
    org.mule.runtime.service;

  exports org.mule.service.http.netty.impl.service to
    org.mule.runtime.service,
    org.mule.service.http,
    com.mulesoft.mule.service.http.ee;

  exports org.mule.service.http.netty.impl.server to
    com.mulesoft.mule.service.http.ee;

  exports org.mule.service.http.netty.impl.client to
    com.mulesoft.mule.service.http.ee;

  exports org.mule.service.http.netty.impl.server.util to
    com.mulesoft.mule.service.http.ee;

  exports org.mule.service.http.netty.impl.message to
    com.mulesoft.mule.service.http.ee;

  exports org.mule.service.http.netty.impl.util to
    com.mulesoft.mule.service.http.ee;
}
