/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.message;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;

public abstract class Http2FramesHandlerAdapter extends ChannelInboundHandlerAdapter implements Http2FramesHandler {

  @Override
  public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
    if (msg instanceof Http2DataFrame) {
      onDataFrameRead(ctx, (Http2DataFrame) msg);
    } else if (msg instanceof Http2HeadersFrame) {
      onHeadersFrameRead(ctx, (Http2HeadersFrame) msg);
    } else {
      super.channelRead(ctx, msg);
    }
  }
}
