/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.auth;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.notNullValue;
import static org.hamcrest.Matchers.nullValue;
import static org.hamcrest.Matchers.startsWith;

import org.mule.tck.junit4.AbstractMuleTestCase;

import io.qameta.allure.Issue;
import org.junit.Test;

@Issue("W-15867900")
public class BasicAuthHeaderFactoryTestCase extends AbstractMuleTestCase {

  private static final String TEST_USER = "Eze";
  private static final String TEST_PASSWORD = "ThisIsASecret";

  @Test
  public void newPreemptiveIsNotFinished() {
    BasicAuthHeaderFactory factory = new BasicAuthHeaderFactory(true, TEST_USER, TEST_PASSWORD);
    assertThat(factory.hasFinished(), is(false));
  }

  @Test
  public void newNonPreemptiveIsNotFinished() {
    BasicAuthHeaderFactory factory = new BasicAuthHeaderFactory(false, TEST_USER, TEST_PASSWORD);
    assertThat(factory.hasFinished(), is(false));
  }

  @Test
  public void preemptiveReturnsTheHeaderInFirstCallAndBecomesFinished() {
    BasicAuthHeaderFactory factory = new BasicAuthHeaderFactory(true, TEST_USER, TEST_PASSWORD);
    String header = factory.getNextHeader(null);
    assertThat(header, notNullValue());
    assertThat(factory.hasFinished(), is(true));
  }

  @Test
  public void nonPreemptiveReturnsTheHeaderInSecondCallAndThenBecomesFinished() {
    BasicAuthHeaderFactory factory = new BasicAuthHeaderFactory(false, TEST_USER, TEST_PASSWORD);

    // first header is null
    String firstHeader = factory.getNextHeader(null);
    assertThat(firstHeader, nullValue());

    // we didn't finish yet
    assertThat(factory.hasFinished(), is(false));

    // second header is generated
    String secondHeader = factory.getNextHeader(null);
    assertThat(secondHeader, notNullValue());
    assertThat(secondHeader, startsWith("Basic "));

    // now we did finish
    assertThat(factory.hasFinished(), is(true));
  }
}
