/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.provider;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.instanceOf;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.http.api.HttpService;
import org.mule.service.http.netty.impl.service.NettyHttpServiceImplementation;
import org.mule.tck.junit4.AbstractMuleTestCase;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class Http2ServiceProviderTestCase extends AbstractMuleTestCase {

  private NettyHttpServiceProvider httpServiceProvider;

  @Before
  public void setup() {
    SchedulerService schedulerService = Mockito.mock(SchedulerService.class);
    httpServiceProvider = new NettyHttpServiceProvider();
    httpServiceProvider.setSchedulerService(schedulerService);
  }

  @Test
  public void providerCreatesDefinitionWithCorrectClass() {
    ServiceDefinition http2ServiceDefinition = httpServiceProvider.getServiceDefinition();
    assertThat(http2ServiceDefinition.getServiceClass(), is(HttpService.class));
  }

  @Test
  public void createdDefinitionReturnsCorrectServiceImplementation() {
    ServiceDefinition http2ServiceDefinition = httpServiceProvider.getServiceDefinition();
    assertThat(http2ServiceDefinition.getService(), is(instanceOf(NettyHttpServiceImplementation.class)));
  }
}
