/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.tck.junit4.AbstractMuleTestCase;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class ForwardingToListenerInitializerTestCase extends AbstractMuleTestCase {

  @Rule
  public MockitoRule rule = MockitoJUnit.rule();

  @Mock
  private HttpListenerRegistry httpListenerRegistry;

  @Mock
  private SslHandler sslHandler;

  @Mock
  private Channel channel;

  @Mock
  private ChannelPipeline pipeline;

  private ForwardingToListenerInitializer initializer;

  @Before
  public void setUp() {
    when(channel.pipeline()).thenReturn(pipeline);
    initializer = new ForwardingToListenerInitializer(httpListenerRegistry, sslHandler);
  }

  @Test
  public void initializeChannelAddsTheCorrectHandlerAndPassesTheSslHandler() {
    initializer.initChannel(channel);

    ArgumentCaptor<ForwardingToListenerHandler> handlerCaptor = ArgumentCaptor.forClass(ForwardingToListenerHandler.class);
    verify(pipeline).addLast(eq("Forward to HTTP Listener"), handlerCaptor.capture());

    ForwardingToListenerHandler handler = handlerCaptor.getValue();
    assertThat(handler.getSslHandler(), is(sslHandler));
  }
}
