/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.message;

import static org.mule.runtime.api.util.MultiMap.emptyMultiMap;
import static org.mule.runtime.http.api.domain.HttpProtocol.HTTP_1_1;

import static java.util.Collections.emptyList;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import java.net.URI;
import java.util.Collection;

public class BaseHttp2Request implements HttpRequest {

  private final String method;
  private final String path;
  private final HttpEntity entity;

  public BaseHttp2Request(String method, String path, HttpEntity entity) {
    this.method = method;
    this.path = path;
    this.entity = entity;
  }

  @Override
  public HttpEntity getEntity() {
    return entity;
  }

  @Override
  public Collection<String> getHeaderNames() {
    return emptyList();
  }

  @Override
  public String getHeaderValue(String headerName) {
    return null;
  }

  @Override
  public String getHeaderValueIgnoreCase(String headerName) {
    return null;
  }

  @Override
  public Collection<String> getHeaderValues(String headerName) {
    return emptyList();
  }

  @Override
  public Collection<String> getHeaderValuesIgnoreCase(String headerName) {
    return emptyList();
  }

  @Override
  public MultiMap<String, String> getHeaders() {
    return emptyMultiMap();
  }

  @Override
  public HttpProtocol getProtocol() {
    // TODO: HTTP_2
    return HTTP_1_1;
  }

  @Override
  public String getPath() {
    return path;
  }

  @Override
  public String getMethod() {
    return method;
  }

  @Override
  public URI getUri() {
    return null;
  }

  @Override
  public MultiMap<String, String> getQueryParams() {
    return null;
  }
}
