/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.util;

import static org.mule.service.http.netty.impl.util.NettyUtils.shouldWrapAsRemotelyClosed;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;

import io.netty.handler.timeout.ReadTimeoutException;

public class ReactorNettyUtils {

  public static Throwable onErrorMap(Throwable error) {
    if (shouldWrapAsRemotelyClosed(error)) {
      return new IOException("Remotely closed", error);
    } else if (error instanceof ReadTimeoutException) {
      return new TimeoutException("Timeout exceeded");
    } else if (error instanceof URISyntaxException) {
      return new IllegalArgumentException(error);
    }
    return error;
  }
}

