/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client;

import static org.mule.runtime.http.api.HttpConstants.HttpStatus.OK;
import static org.mule.runtime.http.api.HttpHeaders.Names.UPGRADE;
import static org.mule.runtime.http.api.domain.message.response.HttpResponse.builder;

import static java.lang.String.format;
import static java.nio.charset.StandardCharsets.UTF_8;

import static org.apache.http.entity.ContentType.create;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.utils.server.HardcodedResponseTcpServer;
import org.mule.tck.junit4.rule.DynamicPort;

import io.qameta.allure.Issue;
import org.apache.http.client.fluent.Request;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@Issue("W-15631402")
public class HttpH2CUpgradeRequestTestCase {

  private static final String RESPONSE = "response";

  private static final String REQUEST = "tests";

  private HttpClient client;

  @Rule
  public DynamicPort serverPort = new DynamicPort("serverPort");

  @Rule
  public HardcodedResponseTcpServer server = new HardcodedResponseTcpServer(serverPort.getNumber());

  @Before
  public void setUp() {
    client = NettyHttpClient.builder().build();
    client.start();
  }

  @After
  public void closeClient() {
    if (client != null) {
      client.stop();
    }
  }

  @Test
  public void whenSettingUpgradeHeaderDoesNotTimeOut() throws Exception {
    Request request = Request.Post(format("http://localhost:%d", serverPort.getNumber()))
        .bodyString(new String(REQUEST.getBytes()), create("text/plain", UTF_8))
        .addHeader(UPGRADE, "h2c");

    HttpResponse response = builder().entity(new ByteArrayHttpEntity(RESPONSE.getBytes())).build();

    assertThat(response.getStatusCode(), is(OK.getStatusCode()));
    assertThat(IOUtils.toString(response.getEntity().getContent()), is(RESPONSE));
  }

}
