/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.utils.client;

import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;

public class TestHttp2StreamHandler {

  private final Http2StreamChannel streamChannel;
  private final TestHttp2ClientResponseHandler streamFrameResponseHandler;

  public TestHttp2StreamHandler(Channel connectionChannel) {
    streamFrameResponseHandler = new TestHttp2ClientResponseHandler();
    Http2StreamChannelBootstrap streamChannelBootstrap = new Http2StreamChannelBootstrap(connectionChannel);
    streamChannel = streamChannelBootstrap.open().syncUninterruptibly().getNow();
    streamChannel.pipeline().addLast(streamFrameResponseHandler);
  }

  public ChannelFuture writeAndFlush(Http2Frame http2Frame) {
    return streamChannel.writeAndFlush(http2Frame);
  }

  public boolean awaitResponseSuccessfullyCompleted() {
    return streamFrameResponseHandler.awaitResponseSuccessfullyCompleted();
  }

  public HttpResponse getResponse() {
    return streamFrameResponseHandler.getResponse();
  }

  public ChannelFuture write(Http2HeadersFrame headersFrame) {
    return streamChannel.write(headersFrame);
  }

  public ByteBuf allocateByteBuf() {
    return streamChannel.alloc().buffer();
  }
}
