/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.service.http.netty.impl.client.ChunkedHttpEntityPublisher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;

public class ChunkedHttpEntityPublisherTestCase
extends AbstractMuleTestCase {
    @Test
    public void requestLargerAmountOfChunks_EntityLargerThanBuffer() {
        String message = "Hello from client, post request to existing path. This is an stream";
        int smallBufferSize = 20;
        int expectedNumberOfChunks = ChunkedHttpEntityPublisherTestCase.calculateNumberOfChunks(message, smallBufferSize);
        InputStreamHttpEntity entity = ChunkedHttpEntityPublisherTestCase.createEntity(message);
        ChunkedHttpEntityPublisher publisher = new ChunkedHttpEntityPublisher((HttpEntity)entity, smallBufferSize);
        TestSubscriber testSubscriber = new TestSubscriber(10);
        publisher.subscribe((CoreSubscriber)testSubscriber);
        MatcherAssert.assertThat((Object)testSubscriber.getReceivedChunks(), (Matcher)Matchers.is((Object)expectedNumberOfChunks));
        MatcherAssert.assertThat((Object)testSubscriber.getAggregatedContentAsString(), (Matcher)Matchers.is((Object)message));
        MatcherAssert.assertThat((Object)testSubscriber.isCompleteCalled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void requestLargerAmountOfChunks_EntitySmallerThanBuffer() {
        String message = "Hello from client, post request to existing path. This is an stream";
        int bufferSize = message.length() * 2;
        int expectedNumberOfChunks = ChunkedHttpEntityPublisherTestCase.calculateNumberOfChunks(message, bufferSize);
        InputStreamHttpEntity entity = ChunkedHttpEntityPublisherTestCase.createEntity(message);
        ChunkedHttpEntityPublisher publisher = new ChunkedHttpEntityPublisher((HttpEntity)entity, bufferSize);
        TestSubscriber testSubscriber = new TestSubscriber(10);
        publisher.subscribe((CoreSubscriber)testSubscriber);
        MatcherAssert.assertThat((Object)testSubscriber.getReceivedChunks(), (Matcher)Matchers.is((Object)expectedNumberOfChunks));
        MatcherAssert.assertThat((Object)testSubscriber.getAggregatedContentAsString(), (Matcher)Matchers.is((Object)message));
        MatcherAssert.assertThat((Object)testSubscriber.isCompleteCalled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void requestExactAmountOfChunks_RequestLargerThanBuffer() {
        String message = "Hello from client, post request to existing path. This is an stream";
        int smallBufferSize = 20;
        int expectedNumberOfChunks = ChunkedHttpEntityPublisherTestCase.calculateNumberOfChunks(message, smallBufferSize);
        InputStreamHttpEntity entity = ChunkedHttpEntityPublisherTestCase.createEntity(message);
        ChunkedHttpEntityPublisher publisher = new ChunkedHttpEntityPublisher((HttpEntity)entity, smallBufferSize);
        TestSubscriber testSubscriber = new TestSubscriber(expectedNumberOfChunks);
        publisher.subscribe((CoreSubscriber)testSubscriber);
        MatcherAssert.assertThat((Object)testSubscriber.getReceivedChunks(), (Matcher)Matchers.is((Object)expectedNumberOfChunks));
        MatcherAssert.assertThat((Object)testSubscriber.getAggregatedContentAsString(), (Matcher)Matchers.is((Object)message));
        MatcherAssert.assertThat((Object)testSubscriber.isCompleteCalled(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void requestLessAmountOfChunks_RequestLargerThanBuffer() {
        String message = "Hello from client, post request to existing path. This is an stream";
        int smallBufferSize = 20;
        int chunksToRequest = ChunkedHttpEntityPublisherTestCase.calculateNumberOfChunks(message, smallBufferSize) - 1;
        InputStreamHttpEntity entity = ChunkedHttpEntityPublisherTestCase.createEntity(message);
        ChunkedHttpEntityPublisher publisher = new ChunkedHttpEntityPublisher((HttpEntity)entity, smallBufferSize);
        TestSubscriber testSubscriber = new TestSubscriber(chunksToRequest);
        publisher.subscribe((CoreSubscriber)testSubscriber);
        MatcherAssert.assertThat((Object)testSubscriber.getReceivedChunks(), (Matcher)Matchers.is((Object)chunksToRequest));
        MatcherAssert.assertThat((Object)testSubscriber.getAggregatedContentAsString(), (Matcher)Matchers.is((Object)message.substring(0, smallBufferSize * chunksToRequest)));
        MatcherAssert.assertThat((Object)testSubscriber.isCompleteCalled(), (Matcher)Matchers.is((Object)false));
    }

    private static int calculateNumberOfChunks(String data, int chunkSize) {
        return (int)Math.ceil(1.0f * (float)data.length() / (float)chunkSize);
    }

    private static InputStreamHttpEntity createEntity(String message) {
        return new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(message.getBytes(StandardCharsets.UTF_8)));
    }

    public static class TestSubscriber
    implements CoreSubscriber<ByteBuf> {
        private final AtomicInteger receivedChunks = new AtomicInteger(0);
        private final AtomicBoolean isCompleteCalled = new AtomicBoolean(false);
        private final int chunksToRequestOnSubscribe;
        private final StringBuilder receivedContentBuilder;

        public TestSubscriber(int chunksToRequestOnSubscribe) {
            this.chunksToRequestOnSubscribe = chunksToRequestOnSubscribe;
            this.receivedContentBuilder = new StringBuilder();
        }

        public void onSubscribe(Subscription subscription) {
            subscription.request((long)this.chunksToRequestOnSubscribe);
        }

        public void onNext(ByteBuf byteBuf) {
            this.receivedChunks.incrementAndGet();
            byte[] bytes = new byte[byteBuf.readableBytes()];
            byteBuf.readBytes(bytes);
            this.receivedContentBuilder.append(new String(bytes));
        }

        public void onError(Throwable throwable) {
        }

        public void onComplete() {
            this.isCompleteCalled.set(true);
        }

        public int getReceivedChunks() {
            return this.receivedChunks.get();
        }

        public boolean isCompleteCalled() {
            return this.isCompleteCalled.get();
        }

        public String getAggregatedContentAsString() {
            return this.receivedContentBuilder.toString();
        }
    }
}

