/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.proxy;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.proxy.ProxyConnectException;

/**
 * Specific case of a connection failure, which may include headers from the proxy.
 */
public final class HttpProxyConnectException extends ProxyConnectException {

  private static final long serialVersionUID = 9067307131174235737L;

  private final HttpHeaders headers;

  /**
   * @param message The failure message.
   * @param headers Header associated with the connection failure. May be {@code null}.
   */
  public HttpProxyConnectException(String message, HttpHeaders headers) {
    super(message);
    this.headers = headers;
  }

  /**
   * Returns headers, if any. May be {@code null}.
   */
  public HttpHeaders headers() {
    return headers;
  }
}
