/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.message;

import static org.mule.runtime.api.util.MultiMap.emptyMultiMap;

import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.HttpConstants.HttpStatus;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import java.util.Collection;
import java.util.Collections;

public class BaseHttp2Response implements HttpResponse {

  private final HttpStatus httpStatus;
  private final HttpEntity entity;

  public BaseHttp2Response(HttpStatus httpStatus, HttpEntity entity) {
    this.httpStatus = httpStatus;
    this.entity = entity;
  }

  @Override
  public HttpEntity getEntity() {
    return entity;
  }

  @Override
  public Collection<String> getHeaderNames() {
    // TODO: Headers?
    return Collections.emptyList();
  }

  @Override
  public String getHeaderValue(String headerName) {
    return null;
  }

  @Override
  public String getHeaderValueIgnoreCase(String headerName) {
    return null;
  }

  @Override
  public Collection<String> getHeaderValues(String headerName) {
    return null;
  }

  @Override
  public Collection<String> getHeaderValuesIgnoreCase(String headerName) {
    return null;
  }

  @Override
  public MultiMap<String, String> getHeaders() {
    return emptyMultiMap();
  }

  @Override
  public int getStatusCode() {
    return httpStatus.getStatusCode();
  }

  @Override
  public String getReasonPhrase() {
    return httpStatus.getReasonPhrase();
  }
}
