/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.ssl.SslHandler;

public class ForwardingToListenerInitializer extends ChannelInitializer<Channel> {

  public static final String FORWARD_TO_HTTP_LISTENER = "Forward to HTTP Listener";
  private final HttpListenerRegistry httpListenerRegistry;
  private final SslHandler sslHandler;

  public ForwardingToListenerInitializer(HttpListenerRegistry httpListenerRegistry, SslHandler sslHandler) {
    this.httpListenerRegistry = httpListenerRegistry;
    this.sslHandler = sslHandler;
  }

  @Override
  protected void initChannel(Channel channel) {
    channel.pipeline().addLast(FORWARD_TO_HTTP_LISTENER,
                               new ForwardingToListenerHandler(httpListenerRegistry, sslHandler));
  }
}
