/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.streaming;

import org.mule.runtime.http.api.server.async.ResponseStatusCallback;

/**
 * Adapter class that wraps a {@link ResponseStatusCallback} and implements the {@link StatusCallback} interface.
 * <p>
 * This adapter is used to convert the {@link ResponseStatusCallback} into a {@link StatusCallback}, allowing it to be passed into
 * other components that expect a {@link StatusCallback}. It provides the necessary implementation for success and failure
 * handling by delegating the calls to the corresponding methods on the wrapped {@link ResponseStatusCallback}.
 * </p>
 *
 * @see ResponseStatusCallback
 * @see StatusCallback
 */
public class ResponseStatusCallbackAdapter implements StatusCallback {

  private final ResponseStatusCallback responseStatusCallback;

  public ResponseStatusCallbackAdapter(ResponseStatusCallback responseStatusCallback) {
    this.responseStatusCallback = responseStatusCallback;
  }

  @Override
  public void onSuccess() {
    responseStatusCallback.responseSendSuccessfully();
  }

  @Override
  public void onFailure(Throwable throwable) {
    responseStatusCallback.responseSendFailure(throwable);
  }
}
