/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.server;

import static org.mule.runtime.http.api.HttpConstants.HttpStatus.NOT_FOUND;

import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.netty.impl.message.BaseHttp2Response;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;

public class NotFoundRequestHandler implements RequestHandler {

  @Override
  public void handleRequest(HttpRequestContext requestContext, HttpResponseReadyCallback responseCallback) {
    responseCallback.responseReady(new BaseHttp2Response(NOT_FOUND, new StringHttpEntity("Not found")), null);
  }
}
