/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.service;

import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.netty.impl.server.ContextHttpServerConnectionFactory;

import java.util.function.Supplier;

/**
 * Implementation of {@link HttpServerFactory} that receives the contextual information in the constructor to end up delegating
 * the {@link HttpServer} creation to a {@link ContextHttpServerConnectionFactory}.
 */
public class ContextHttpServerFactory implements HttpServerFactory {

  private final ContextHttpServerConnectionFactory delegate;
  private final Supplier<Long> shutdownTimeout;

  public ContextHttpServerFactory(ContextHttpServerConnectionFactory delegate, Supplier<Long> shutdownTimeout) {
    this.delegate = delegate;
    this.shutdownTimeout = shutdownTimeout;
  }

  @Override
  public HttpServer create(HttpServerConfiguration configuration) throws ServerCreationException {
    return delegate.create(configuration, shutdownTimeout);
  }

  @Override
  public HttpServer lookup(String name) throws ServerNotFoundException {
    return delegate.lookup(name);
  }
}
