/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.util;

import static java.nio.charset.Charset.defaultCharset;

import static io.netty.handler.logging.LogLevel.DEBUG;
import static reactor.netty.transport.logging.AdvancedByteBufFormat.TEXTUAL;

import java.net.SocketAddress;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler.Sharable;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.logging.LoggingHandler;

/**
 * Handler to print "Wire Logging". This is only considering read, write, flush, connect, and close events. This handler delegates
 * the format to {@link reactor.netty.transport.logging.AdvancedByteBufFormat#TEXTUAL}.
 */
@Sharable
public class HttpLoggingHandler extends ChannelDuplexHandler {

  private static final String LEGACY_WIRE_LOGGER_NAME = "org.mule.service.http.impl.service.HttpMessageLogger";
  private final LoggingHandler delegate;

  public HttpLoggingHandler() {
    this.delegate = TEXTUAL.toLoggingHandler(LEGACY_WIRE_LOGGER_NAME, DEBUG, defaultCharset());
  }

  @Override
  public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
    delegate.channelRead(ctx, msg);
  }

  @Override
  public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
    delegate.write(ctx, msg, promise);
  }

  @Override
  public void flush(ChannelHandlerContext ctx) throws Exception {
    delegate.flush(ctx);
  }

  @Override
  public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise)
      throws Exception {
    delegate.connect(ctx, remoteAddress, localAddress, promise);
  }

  @Override
  public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
    delegate.close(ctx, promise);
  }

  @Override
  public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
    delegate.channelReadComplete(ctx);
  }
}
