/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.proxy;

import static java.lang.String.format;

import org.mule.runtime.http.api.client.proxy.ProxyConfig;

import io.qameta.allure.Issue;
import org.junit.Test;

@Issue("W-16606326")
public class BlindTunnelingProxyTestCase extends AbstractSimpleProxyTestCase {

  public BlindTunnelingProxyTestCase() {
    // When using SSL, the proxy is done via CONNECT (blind tunneling).
    super(true);
  }

  @Test
  @Issue("W-15642778")
  public void testProxyAuthorizationHeaderAbsent() throws Exception {
    ProxyConfig proxyConfig = ProxyConfig.builder()
        .host("localhost")
        .port(proxyPort.getNumber())
        .username("user")
        .password("password")
        .build();

    super.testSendThroughProxy(proxyConfig, "hello_and_check_headers");
  }
}
