/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth;

import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.service.http.netty.impl.client.auth.BasicAuthHeaderFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Issue(value="W-15867900")
public class BasicAuthHeaderFactoryTestCase
extends AbstractMuleTestCase {
    private static final String TEST_USER = "Eze";
    private static final String TEST_PASSWORD = "ThisIsASecret";

    @Test
    public void newPreemptiveIsNotFinished() {
        BasicAuthHeaderFactory factory = new BasicAuthHeaderFactory(true, TEST_USER, TEST_PASSWORD);
        MatcherAssert.assertThat((Object)factory.hasFinished(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void newNonPreemptiveIsNotFinished() {
        BasicAuthHeaderFactory factory = new BasicAuthHeaderFactory(false, TEST_USER, TEST_PASSWORD);
        MatcherAssert.assertThat((Object)factory.hasFinished(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void preemptiveReturnsTheHeaderInFirstCallAndBecomesFinished() {
        BasicAuthHeaderFactory factory = new BasicAuthHeaderFactory(true, TEST_USER, TEST_PASSWORD);
        String header = factory.getNextHeader(null);
        MatcherAssert.assertThat((Object)header, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)factory.hasFinished(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void nonPreemptiveReturnsTheHeaderInSecondCallAndThenBecomesFinished() {
        BasicAuthHeaderFactory factory = new BasicAuthHeaderFactory(false, TEST_USER, TEST_PASSWORD);
        String firstHeader = factory.getNextHeader(null);
        MatcherAssert.assertThat((Object)firstHeader, (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)factory.hasFinished(), (Matcher)Matchers.is((Object)false));
        String secondHeader = factory.getNextHeader(null);
        MatcherAssert.assertThat((Object)secondHeader, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)secondHeader, (Matcher)Matchers.startsWith((String)"Basic "));
        MatcherAssert.assertThat((Object)factory.hasFinished(), (Matcher)Matchers.is((Object)true));
    }
}

