/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.utils.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.netty.impl.message.BaseHttp2Response;
import org.mule.service.http.netty.impl.message.Http2FramesHandlerAdapter;
import org.mule.service.http.netty.impl.message.content.BaseHttpEntity;

public final class TestHttp2ClientResponseHandler
extends Http2FramesHandlerAdapter {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final BaseHttpEntity responseContent = new BaseHttpEntity();
    private HttpResponse response;

    public boolean awaitResponseSuccessfullyCompleted() {
        try {
            return this.latch.await(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            System.err.println("Latch exception: " + ie.getMessage());
            return false;
        }
    }

    public void onHeadersFrameRead(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) throws IOException {
        System.out.println("Received HTTP/2 'stream' frame: " + headersFrame);
        this.response = new BaseHttp2Response(HttpConstants.HttpStatus.getStatusByCode((int)Integer.parseInt(headersFrame.headers().status().toString())), (HttpEntity)this.responseContent);
        if (headersFrame.isEndStream()) {
            this.responseContent.close();
            this.latch.countDown();
        }
    }

    public void onDataFrameRead(ChannelHandlerContext ctx, Http2DataFrame dataFrame) throws IOException {
        System.out.println("Received HTTP/2 'stream' frame: " + dataFrame);
        byte[] frameData = ByteBufUtil.getBytes((ByteBuf)dataFrame.content());
        this.responseContent.feed(frameData, 0, frameData.length);
        if (dataFrame.isEndStream()) {
            this.responseContent.close();
            this.latch.countDown();
        }
    }

    public HttpResponse getResponse() {
        return this.response;
    }
}

