/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.DefaultEventLoop;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.StreamingResponseSender;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.probe.PollingProber;

public class StreamingResponseSenderTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private HttpRequest request;
    @Mock
    private HttpResponse response;
    @Mock
    private Channel channel;
    @Mock
    private ResponseStatusCallback statusCallback;
    private HttpEntity entity;
    private final List<HttpObject> writtenObjects = new ArrayList<HttpObject>();

    @Before
    public void setUp() {
        DefaultEventLoop executor = new DefaultEventLoop();
        Mockito.when((Object)this.channel.eventLoop()).thenReturn((Object)executor);
        Mockito.when((Object)this.request.getProtocol()).thenReturn((Object)HttpProtocol.HTTP_1_1);
        Mockito.when((Object)this.request.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.response.getEntity()).thenAnswer(inv -> this.entity);
        Mockito.when((Object)this.response.getStatusCode()).thenReturn((Object)200);
        Mockito.when((Object)this.response.getReasonPhrase()).thenReturn((Object)"OK");
        this.setUpHeaders(this.response);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)ByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.ctx.newPromise()).thenAnswer(inv -> new DefaultChannelPromise(this.channel));
        this.saveDataWrittenToChannel(this.ctx);
    }

    @Test
    public void createSenderWithNonStreamingEntityFails() {
        this.entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)false);
        IllegalArgumentException thrown = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new StreamingResponseSender(this.request, this.ctx, this.response, this.statusCallback));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)"Response entity must be streaming to use a StreamingResponseSender"));
    }

    @Test
    public void sendInSeveralPartsWithoutContentLength() throws IOException {
        int bufferSize = 8192;
        int extraChunkSize = 10;
        this.entity = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(RandomStringUtils.randomAlphanumeric((int)(2 * bufferSize + extraChunkSize)).getBytes()));
        new StreamingResponseSender(this.request, this.ctx, this.response, this.statusCallback).send();
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)this.writtenObjects.size(), (Matcher)Matchers.is((Object)4));
            MatcherAssert.assertThat((Object)((DefaultHttpContent)this.writtenObjects.get(0)).content().readableBytes(), (Matcher)Matchers.is((Object)bufferSize));
            MatcherAssert.assertThat((Object)((DefaultHttpContent)this.writtenObjects.get(1)).content().readableBytes(), (Matcher)Matchers.is((Object)bufferSize));
            MatcherAssert.assertThat((Object)((DefaultHttpContent)this.writtenObjects.get(2)).content().readableBytes(), (Matcher)Matchers.is((Object)extraChunkSize));
            MatcherAssert.assertThat((Object)this.writtenObjects.get(3), (Matcher)Matchers.is((Object)LastHttpContent.EMPTY_LAST_CONTENT));
            return true;
        });
    }

    @Test
    public void sendStreamWithContentLengthShorterThanDefault() throws IOException {
        int contentLength = 4096;
        this.entity = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(RandomStringUtils.randomAlphanumeric((int)contentLength).getBytes()), (long)contentLength);
        new StreamingResponseSender(this.request, this.ctx, this.response, this.statusCallback).send();
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)this.writtenObjects.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)((DefaultHttpContent)this.writtenObjects.get(0)).content().readableBytes(), (Matcher)Matchers.is((Object)contentLength));
            return true;
        });
    }

    @Test
    public void sendStreamWithContentLengthLongerThanDefault() throws IOException {
        int bufferSize = 8192;
        int extraLength = 20;
        int contentLength = bufferSize + extraLength;
        this.entity = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(RandomStringUtils.randomAlphanumeric((int)contentLength).getBytes()), (long)contentLength);
        new StreamingResponseSender(this.request, this.ctx, this.response, this.statusCallback).send();
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)this.writtenObjects.size(), (Matcher)Matchers.is((Object)2));
            MatcherAssert.assertThat((Object)((DefaultHttpContent)this.writtenObjects.get(0)).content().readableBytes(), (Matcher)Matchers.is((Object)bufferSize));
            MatcherAssert.assertThat((Object)((DefaultHttpContent)this.writtenObjects.get(1)).content().readableBytes(), (Matcher)Matchers.is((Object)extraLength));
            return true;
        });
    }

    @Test
    public void sendEmptyStreamingEntity() throws IOException {
        this.entity = new InputStreamHttpEntity((InputStream)new ByteArrayInputStream(new byte[0]), 0L);
        new StreamingResponseSender(this.request, this.ctx, this.response, this.statusCallback).send();
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)this.writtenObjects.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)this.writtenObjects.get(0), (Matcher)Matchers.is((Object)LastHttpContent.EMPTY_LAST_CONTENT));
            return true;
        });
    }

    @Test
    public void sendStreamThatFailsToReadWithClosedState() throws IOException {
        this.entity = new InputStreamHttpEntity(this.streamFailingWith(new IllegalStateException("Buffer is closed")));
        new StreamingResponseSender(this.request, this.ctx, this.response, this.statusCallback).send();
        PollingProber.probe(() -> {
            MatcherAssert.assertThat((Object)this.writtenObjects.size(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)this.writtenObjects.get(0), (Matcher)Matchers.is((Object)LastHttpContent.EMPTY_LAST_CONTENT));
            return true;
        });
    }

    @Test
    public void sendStreamThatFailsToReadWithOtherException() throws IOException {
        IllegalStateException expected = new IllegalStateException("Some unexpected error");
        this.entity = new InputStreamHttpEntity(this.streamFailingWith(expected));
        RuntimeException thrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> new StreamingResponseSender(this.request, this.ctx, this.response, this.statusCallback).send());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.is((Object)expected.getMessage()));
    }

    private void setUpHeaders(HttpResponse response) {
        MultiMap headers = new MultiMap();
        Mockito.when((Object)response.getHeaders()).thenReturn((Object)headers);
    }

    private void saveDataWrittenToChannel(ChannelHandlerContext context) {
        Mockito.when((Object)context.writeAndFlush(Mockito.any(HttpObject.class), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenAnswer(invocation -> {
            HttpObject toWrite = (HttpObject)invocation.getArgument(0, HttpObject.class);
            this.writtenObjects.add(toWrite);
            ChannelPromise promise = (ChannelPromise)invocation.getArgument(1, ChannelPromise.class);
            promise.setSuccess().get();
            return null;
        });
    }

    private InputStream streamFailingWith(final RuntimeException exception) {
        return new InputStream(){

            @Override
            public int read() {
                throw exception;
            }
        };
    }
}

