/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.benchmark;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.MethodRequestMatcher;
import org.mule.runtime.http.api.server.PathAndMethodRequestMatcher;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

public class BenchmarkTestServer {
    private final HttpServer server;
    private final String host;
    private final int port;
    private final HttpListenerRegistry httpListenerRegistry;

    public BenchmarkTestServer(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.httpListenerRegistry = new HttpListenerRegistry();
        this.server = NettyHttpServer.builder().withShutdownTimeout(() -> 5000L).withServerAddress(new InetSocketAddress(host, port)).withHttpListenerRegistry(this.httpListenerRegistry).withClientChannelHandler(new AcceptedConnectionChannelInitializer(this.httpListenerRegistry, true, 30000, 10000L, null)).build();
        this.server.start();
    }

    public void start() throws IOException {
        this.server.start();
    }

    public void stop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public RequestHandlerManager addRequestHandler(String path, RequestHandler requestHandler) {
        return this.httpListenerRegistry.addRequestHandler(this.server, requestHandler, PathAndMethodRequestMatcher.builder().methodRequestMatcher(MethodRequestMatcher.acceptAll()).path(path).build());
    }
}

