/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.av;

/**
 * Represents a generic AV_PAIR structure used in NTLM authentication, which pairs a type identifier with raw byte data. This
 * class serves as a base for more specific AV_PAIR types, such as flags and channel bindings.
 *
 * <p>
 * This implementation is based on the jcifs library, available at:
 * <a href="https://github.com/codelibs/jcifs">https://github.com/codelibs/jcifs</a>
 * </p>
 *
 * @see <a href="https://github.com/codelibs/jcifs">jcifs on GitHub</a>
 */
public class AvPair {

  /** End of list (EOL) type. */
  public static final int MsvAvEOL = 0x0;

  /** Flags type. */
  public static final int MsvAvFlags = 0x6;

  /** Timestamp type. */
  public static final int MsvAvTimestamp = 0x7;

  /** Single host type. */
  public static final int MsvAvSingleHost = 0x08;

  /** Target name type. */
  public static final int MsvAvTargetName = 0x09;

  /** Channel bindings type. */
  public static final int MsvAvChannelBindings = 0x0A;

  private final int type;
  private final byte[] raw;

  /**
   * Constructs an instance of {@code AvPair} with the specified type and raw data.
   *
   * @param type the type identifier for the AV_PAIR.
   * @param raw  the raw byte data associated with the specified type.
   */
  public AvPair(int type, byte[] raw) {
    this.type = type;
    this.raw = raw;
  }

  /**
   * Returns the type identifier of the AV_PAIR.
   *
   * @return the type identifier.
   */
  public final int getType() {
    return this.type;
  }

  /**
   * Returns the raw byte data associated with this AV_PAIR.
   *
   * @return the raw byte data.
   */
  public final byte[] getRaw() {
    return this.raw;
  }
}
