/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.impl.util;

import static java.nio.charset.StandardCharsets.UTF_8;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.service.http.netty.impl.streaming.BidirectionalByteBufferStream;
import org.mule.tck.junit4.AbstractMuleTestCase;

import java.io.IOException;

import org.junit.Test;

public class BidirectionalByteBufferTestCase extends AbstractMuleTestCase {

  @Test
  public void readFromEmpty() throws IOException {
    byte[] aux = new byte[5];

    BidirectionalByteBufferStream empty = new BidirectionalByteBufferStream();
    int result = empty.read(aux, 0, 5);
    assertThat(result, is(0));
  }

  @Test
  public void writeOneChunk_readOneChunk() throws IOException {
    byte[] toWrite = "Hello world".getBytes(UTF_8);
    byte[] readBytes = "____________________".getBytes(UTF_8);

    BidirectionalByteBufferStream bidiBuf = new BidirectionalByteBufferStream();
    bidiBuf.write(toWrite, 0, toWrite.length);

    int result = bidiBuf.read(readBytes, 0, toWrite.length);
    assertThat(result, is(toWrite.length));
    assertThat(new String(readBytes), is("Hello world_________"));
  }

  @Test
  public void writeOneChunk_readTwoChunks() throws IOException {
    byte[] toWrite = "Hello world".getBytes(UTF_8);
    byte[] readBytes = "____________________".getBytes(UTF_8);

    BidirectionalByteBufferStream bidiBuf = new BidirectionalByteBufferStream();
    bidiBuf.write(toWrite, 0, toWrite.length);

    int result1 = bidiBuf.read(readBytes, 0, 5);
    int result2 = bidiBuf.read(readBytes, 5, toWrite.length - 5);

    assertThat(result1, is(5));
    assertThat(result2, is(toWrite.length - 5));
    assertThat(new String(readBytes), is("Hello world_________"));
  }

  @Test
  public void writeTwoChunks_readOneChunk() throws IOException {
    byte[] toWrite = "Hello world".getBytes(UTF_8);
    byte[] readBytes = "____________________".getBytes(UTF_8);

    BidirectionalByteBufferStream bidiBuf = new BidirectionalByteBufferStream();
    bidiBuf.write(toWrite, 0, 5);
    bidiBuf.write(toWrite, 5, toWrite.length - 5);

    int result = bidiBuf.read(readBytes, 0, toWrite.length);
    assertThat(result, is(toWrite.length));
    assertThat(new String(readBytes), is("Hello world_________"));
  }

  @Test
  public void writeTwoChunks_readTwoChunks() throws IOException {
    byte[] toWrite = "Hello world".getBytes(UTF_8);
    byte[] readBytes = "____________________".getBytes(UTF_8);

    BidirectionalByteBufferStream bidiBuf = new BidirectionalByteBufferStream();
    bidiBuf.write(toWrite, 0, 5);
    bidiBuf.write(toWrite, 5, toWrite.length - 5);

    int result1 = bidiBuf.read(readBytes, 0, 6);
    int result2 = bidiBuf.read(readBytes, 6, toWrite.length - 6);

    assertThat(result1, is(6));
    assertThat(result2, is(toWrite.length - 6));
    assertThat(new String(readBytes), is("Hello world_________"));
  }
}
