/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.util;

import java.nio.charset.Charset;

/**
 * Utility class for handling string encoding and conversion.
 * <p>
 * This class provides methods to convert strings to byte arrays using specified encodings, particularly for NTLM authentication.
 * </p>
 * <p>
 * This implementation is based on the jcifs library, available at <a href="https://github.com/kevinboone/jcifs">jcifs GitHub
 * Repository</a>.
 * </p>
 */
public class Strings {

  private static final Charset UNI_ENCODING = Charset.forName("UTF-16LE");

  public static byte[] getUNIBytes(String str) {
    return getBytes(str, UNI_ENCODING);
  }

  public static byte[] getBytes(String str, Charset encoding) {
    if (str == null) {
      return new byte[0];
    }
    return str.getBytes(encoding);
  }
}
