/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.impl.server;

import static org.mule.functional.junit4.matchers.ThrowableMessageMatcher.hasMessage;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.Assert.assertThrows;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

import org.mule.service.http.netty.impl.server.HttpWithAPNServerHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;

import java.util.function.BiConsumer;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SslHandler;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class HttpWithAPNServerHandlerTestCase extends AbstractMuleTestCase {

  @Rule
  public MockitoRule rule = MockitoJUnit.rule();

  private HackyHttpWithAPNServerHandler handler;

  @Spy
  private BiConsumer<ChannelPipeline, SslHandler> mockHttp1Consumer;

  @Before
  public void setUp() {
    handler = new HackyHttpWithAPNServerHandler(mockHttp1Consumer);
  }

  @Test
  public void filtersOutHttp_1_0_Requests() {
    IllegalStateException exception = assertThrows(IllegalStateException.class, () -> handler.configure("http/1.0"));
    assertThat(exception, hasMessage("Unknown protocol: http/1.0"));
  }

  @Test
  public void callsHttp_1_1_Consumer() throws Exception {
    handler.configure("http/1.1");
    verify(mockHttp1Consumer).accept(any(), any());
  }


  /**
   * Class extending {@link HttpWithAPNServerHandler} but allowing to access
   * {@link HackyHttpWithAPNServerHandler#configure(String)} in a package-private way.
   */
  private static class HackyHttpWithAPNServerHandler extends HttpWithAPNServerHandler {

    HackyHttpWithAPNServerHandler(BiConsumer<ChannelPipeline, SslHandler> http1Configurer) {
      super(http1Configurer, null);
    }

    void configure(String protocol) throws Exception {
      this.configurePipeline(mock(ChannelHandlerContext.class), protocol);
    }
  }
}
