/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.utils;

import org.mule.tck.http.TestProxyServer;

import org.junit.rules.ExternalResource;

public class HttpProxyRule extends ExternalResource {

  private final TestProxyServer testProxyServer;

  public HttpProxyRule(int listenPort, int targetPort, boolean https) {
    testProxyServer = new TestProxyServer(listenPort, targetPort, https);
  }

  @Override
  protected void before() throws Throwable {
    testProxyServer.start();
  }

  @Override
  protected void after() {
    try {
      testProxyServer.stop();
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }

  public boolean hasConnections() {
    return testProxyServer.hasConnections();
  }
}
