/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.test.netty.impl.client.auth.ntlm;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import org.mule.service.http.netty.impl.client.auth.ntlm.NtlmMessageFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Base64;

import jcifs.ntlmssp.Type3Message;
import org.junit.Test;

public class NtlmMessageFactoryTestCase extends AbstractMuleTestCase {

  private static final String TEST_DOMAIN = "someDomain";
  private static final String TEST_WORKSTATION = "workstation";
  private static final String TEST_USERNAME = "username";
  private static final String TEST_PASSWORD = "sup3rStr0ngP4ssw0rd";

  private static final String TYPE_2_CHALLENGE_BASE64 = "TlRMTVNTUAACAAAAAAAAACgAAAABggAAU3J2Tm9uY2UAAAAAAAAAAA==";
  private static final byte[] TYPE_2_MESSAGE_RAW = Base64.getDecoder().decode(TYPE_2_CHALLENGE_BASE64);

  @Test
  public void generateType1AlwaysReturnTheSame() {
    NtlmMessageFactory ntlmMessageFactory = new NtlmMessageFactory(TEST_DOMAIN, TEST_WORKSTATION, TEST_USERNAME, TEST_PASSWORD);
    byte[] first = ntlmMessageFactory.createType1Message();
    byte[] second = ntlmMessageFactory.createType1Message();
    NtlmMessageFactory anotherEngine = new NtlmMessageFactory(TEST_DOMAIN, TEST_WORKSTATION, TEST_USERNAME, TEST_PASSWORD);
    byte[] third = anotherEngine.createType1Message();
    assertThat(second, is(first));
    assertThat(third, is(first));
  }

  @Test
  public void generateType3HasTheSpecifiedFields() throws GeneralSecurityException, IOException {
    NtlmMessageFactory ntlmMessageFactory = new NtlmMessageFactory(TEST_DOMAIN, TEST_WORKSTATION, TEST_USERNAME, TEST_PASSWORD);
    byte[] type3MessageRaw = ntlmMessageFactory.createType3Message(TYPE_2_MESSAGE_RAW);
    Type3Message type3Message = new Type3Message(type3MessageRaw);
    assertThat(type3Message.getDomain(), is(TEST_DOMAIN));
    assertThat(type3Message.getWorkstation(), is(TEST_WORKSTATION));
    assertThat(type3Message.getUser(), is(TEST_USERNAME));
  }
}
