/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.auth;

/**
 * Interface that represents a factory of messages, different type of authentication return different values but the main logic is
 * that the server will ask or not for first and second challenges and the client will generate those messages
 */
public interface AuthHeaderFactory {

  /**
   * @return whether the authentication method already finished, and it won't produce any more authentication headers.
   */
  boolean hasFinished();

  /**
   * Returns the next authentication header value given the factory status (it's stateful a-priori), and the passed
   * WWW-Authenticate header.
   * 
   * @param wwwAuthenticateHeader the WWW-Authenticate received as server challenge.
   * @return the next authentication header, if corresponds, or null otherwise.
   * @throws Exception if an error occurs while calculating the next header value.
   */
  String getNextHeader(String wwwAuthenticateHeader) throws Exception;
}
