/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm;

/**
 * This class defines the flags used in NTLM authentication messages.
 * <p>
 * These flags specify capabilities and preferences for the NTLM authentication process.
 * </p>
 * <p>
 * This implementation is based on the jcifs library, available at <a href="https://github.com/kevinboone/jcifs">jcifs GitHub
 * Repository</a>.
 * </p>
 */
public class NtlmFlags {

  /**
   * Indicates whether Unicode strings are supported or used.
   */
  public static final int NTLMSSP_NEGOTIATE_UNICODE = 0x00000001;

  /**
   * Indicates whether OEM strings are supported or used.
   */
  public static final int NTLMSSP_NEGOTIATE_OEM = 0x00000002;

  /**
   * Specifies that communication across the authenticated channel should carry a digital signature (message integrity).
   */
  public static final int NTLMSSP_NEGOTIATE_SIGN = 0x00000010;

  /**
   * Indicates support for NTLM authentication.
   */
  public static final int NTLMSSP_NEGOTIATE_NTLM = 0x00000200;

  /**
   * Sent by the server in the Type 2 message to indicate that it is including a Target Information block in the message. The
   * Target Information block is used in the calculation of the NTLMv2 response.
   */
  public static final int NTLMSSP_NEGOTIATE_TARGET_INFO = 0x00800000;

  /**
   * Indicates the NTLM version negotiation.
   */
  public static final int NTLMSSP_NEGOTIATE_VERSION = 0x2000000;

  /**
   * Request explicit key exchange.
   */
  public static final int NTLMSSP_NEGOTIATE_KEY_EXCH = 0x40000000;

}
